#include <linux/kernel.h>
#include <linux/module.h>

/*
 * Tutorial hello world module init.
 * @return int == 0: Success. 
 *             < 0:  Fail, negative errno number.
 */
static int __init hello_world_init(void)
{	printk(KERN_INFO "%s: Hello world.\n", __func__);
	return 0;
}

/*
 * Tutorial hello world module exit.
 * @return void
 */
static void __exit hello_world_exit(void)
{	printk(KERN_INFO "%s: Goodbye world.\n", __func__);
}

module_init(hello_world_init);
module_exit(hello_world_exit);

MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("Tutorial hello world.");
MODULE_AUTHOR("Your name or email address.");
